﻿namespace Microsoft.Samples.PlanMyNight.Web.Infrastructure
{
    using System;
    using System.ComponentModel.Composition;
    using System.Globalization;
    using System.Web;
    using System.Web.Caching;
    using Microsoft.Samples.PlanMyNight.Data;

    [Export(typeof(ICachingProvider))]
    [PartCreationPolicy(CreationPolicy.NonShared)]
    public class AspNetCachingProvider : ICachingProvider
    {
        private readonly Cache cache;

        public AspNetCachingProvider()
        {
            this.cache = HttpContext.Current.Cache;
        }

        public bool HasKey(string container, string key)
        {
            return this.cache.Get(GetKey(container, key)) != null;
        }

        public object Get(string container, string key)
        {
            return this.cache.Get(GetKey(container, key));
        }

        public void Add(string container, string key, object value, TimeSpan timeout)
        {
            this.cache.Insert(GetKey(container, key), value, null, DateTime.UtcNow.AddMinutes(timeout.TotalMinutes), Cache.NoSlidingExpiration);
        }

        public void Remove(string container, string key)
        {
            this.cache.Remove(GetKey(container, key));
        }

        private static string GetKey(string container, string key)
        {
            return string.Format(CultureInfo.InvariantCulture, "{0}:{1}", container, key);
        }
    }
}
